#ifndef _FCMD_H_
#define _FCMD_H_

#include "xgpio.h"

void fcmd_reset(XGpio* cmd_gpio, XGpio* data_gpio, int channel);
void fcmd_activate_nvddr2(XGpio* cmd_gpio, XGpio* data_gpio, int channel);
void fcmd_read_id(XGpio* cmd_gpio, XGpio* data_gpio, int channel, u8 buf[10]);
void fcmd_read_page(XGpio* cmd_gpio, XGpio* data_gpio, int channel,
                    unsigned int die, unsigned int plane, unsigned int block,
                    unsigned int page, unsigned int col);
u8 fcmd_is_ready(XGpio* cmd_gpio, XGpio* data_gpio, int channel,
                 unsigned int die, int* error);
int fcmd_wait_ready(XGpio* cmd_gpio, XGpio* data_gpio, int channel,
                    unsigned int die, unsigned int plane);
void fcmd_read_page_data_sync(XGpio* cmd_gpio, XGpio* data_gpio, int channel,
                              unsigned int die, unsigned int plane,
                              unsigned int block, unsigned int page,
                              unsigned int col, u8* data, size_t size);
void fcmd_program_page_sync(XGpio* cmd_gpio, XGpio* data_gpio, int channel,
                            unsigned int die, unsigned int plane,
                            unsigned int block, unsigned int page,
                            unsigned int col, const u8* data, size_t size);
void fcmd_erase_block(XGpio* cmd_gpio, XGpio* data_gpio, int channel,
                      unsigned int die, unsigned int plane, unsigned int block);

#endif
