#include <string.h>

#include "proto.h"

void worker_report_stats(void);

static void report_stats(void)
{
    ftl_report_stats();
    worker_report_stats();
}

static void handle_input(const u8* buf, size_t count)
{
    while (count > 0 && (buf[count - 1] == '\n' || buf[count - 1] == '\r'))
        count--;

    if (count == 6 && !memcmp(buf, "report", count)) {
        report_stats();
    } else if (count == 12 && !memcmp(buf, "dump_profile", count)) {
        profile_dump();
    } else if (count == 4 && !memcmp(buf, "sync", count)) {
        bm_shutdown();
    }
}

void dbgcon_setup(void) { uart_set_recv_data_handler(handle_input); }
